import React from 'react';

import {EProjectName} from 'constants/common';

import {IWithClassName} from 'types/withClassName';
import EHeaderBorderBottomType from 'components/Header/types/EHeaderBorderBottomType';

import CommonHeader from 'components/Header/Header';

import cx from './Header.scss';

interface IHeaderProps extends IWithClassName {
    project: EProjectName;
    showNavigation?: boolean;
    hasSideSheetNavigation?: boolean;
    withNavCaptions?: boolean;
}

const Header: React.FC<IHeaderProps> = props => {
    const {
        project,
        showNavigation = false,
        hasSideSheetNavigation = false,
        className,
        withNavCaptions,
    } = props;

    return (
        <CommonHeader
            className={cx('header', className)}
            containerClassName={cx('headerContainer')}
            showNavigation={showNavigation}
            hasSideSheetNavigation={hasSideSheetNavigation}
            project={project}
            borderBottomType={EHeaderBorderBottomType.NONE}
            withYandexLogo={false}
            withNavCaptions={withNavCaptions}
        />
    );
};

export default Header;
