import React, {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';

import {useMobile} from 'utilities/hooks/useMobile';
import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import {TErrorActionType} from 'components/ErrorModal/ErrorModal';
import Box from 'components/Box/Box';
import Button from 'components/Button/Button';
import ButtonLink from 'components/ButtonLink/ButtonLink';
import Heading from 'components/Heading/Heading';

import cx from './LayoutError500.scss';

export interface ILayoutError500Props extends IWithClassName {
    title: React.ReactNode;
    subtitle?: React.ReactNode;
    action?: TErrorActionType;
}

const LayoutError500: FunctionComponent<ILayoutError500Props> = ({
    action,
    subtitle,
    title,
}) => {
    const isMobile = useMobile();

    return (
        <div
            className={cx('root', {root_mobile: isMobile})}
            {...prepareQaAttributes({
                current: 'layoutError500',
            })}
        >
            <Box below={isMobile ? 5 : 8} between={isMobile ? 2 : 3}>
                <Heading level="2">{title}</Heading>
                <Box textSize="m" textColor="primary">
                    {subtitle}
                </Box>
            </Box>
            {action && action.type === 'button' && (
                <Button
                    className={cx('button')}
                    {...action.props}
                    onClick={action.handler}
                    theme="primary"
                    size={isMobile ? 'l' : 'm'}
                >
                    {action.title}
                </Button>
            )}
            {action && action.type === 'button-link' && (
                <ButtonLink
                    className={cx('button')}
                    {...action.props}
                    onClick={action.handler}
                    theme="primary"
                    size={isMobile ? 'l' : 'm'}
                >
                    {action.title}
                </ButtonLink>
            )}
        </div>
    );
};

export default LayoutError500;
