import React from 'react';

import {EProjectName} from 'constants/common';

import {IWithClassName} from 'types/withClassName';
import {EFooterProject} from 'components/Footer/types';
import EHeaderBorderBottomType from 'components/Header/types/EHeaderBorderBottomType';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Footer from 'components/Footer/Footer';
import Header from 'components/Header/Header';

import cx from './LayoutLight.scss';

interface ILayoutLightPropTypes extends IWithClassName {
    headerClassName?: string;
    footerClassName?: string;
    project?: EProjectName;
    footerType?: EFooterProject;
}

const LayoutLight: React.FC<ILayoutLightPropTypes> = props => {
    const {
        className,
        headerClassName,
        footerClassName,
        project,
        footerType,
        children,
    } = props;
    const deviceType = useDeviceType();

    return (
        <div className={cx('root', deviceMods('root', deviceType), className)}>
            <Header
                className={cx('header', headerClassName)}
                containerClassName={cx('headerContainer')}
                showNavigation
                hasSideSheetNavigation
                borderBottomType={EHeaderBorderBottomType.NONE}
            />

            <div className={cx('content')}>{children}</div>

            <Footer
                className={footerClassName}
                project={project}
                footerType={footerType}
            />
        </div>
    );
};

export default LayoutLight;
