import {Meta} from '@storybook/react/types-6-0';

import {EProjectName} from 'constants/common';

import {TStorybookFunctionComponent} from 'storybook/types';

import Checkbox from 'components/Checkbox/Checkbox';
import Avatar from 'components/Avatar/Avatar';

import PaymentLayout from './PaymentLayout';

export default {
    title: 'Example/Layout/Payment',
    component: PaymentLayout,
} as Meta;

export const NewPaymentLayout: TStorybookFunctionComponent = () => (
    <PaymentLayout
        header={
            <PaymentLayout.PaymentHeader
                rightSide={
                    <Avatar
                        size="m"
                        src="https://avatars.mds.yandex.net/get-pdb/881477/2398e88e-e017-49bd-94cc-8fec35e73f64/s1200"
                    />
                }
            />
        }
        footer={
            <Checkbox
                size="s"
                checked
                label="Согласен получать новости и выгодные предложения Яндекс.Путешествий"
            />
        }
        orderInfo={
            <PaymentLayout.PaymentOrderInfo
                description={{
                    general:
                        'Апартаменты Chalet With 5 Bedrooms in Cogollos de Guadix',
                    additional: '9 ноября – 10 ноября 9 гостей',
                }}
                orderId="#2923-832726-3234"
                orderType={EProjectName.TRAINS}
            />
        }
    >
        <div
            style={{
                height: 400,
                display: 'flex',
                alignItems: 'center',
                justifyContent: 'center',
                backgroundColor: '#b0c7ee',
            }}
        >
            Payment frame
        </div>
    </PaymentLayout>
);
