import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Box from 'components/Box/Box';
import Avatar from 'components/Avatar/Avatar';

import PaymentHeader from './PaymentHeader';

export default {
    title: 'Example/Layout/Payment/PaymentHeader',
    component: PaymentHeader,
} as Meta;

export const NewPaymentHeader: TStorybookFunctionComponent = () => (
    <Box between="6">
        <PaymentHeader
            rightSide={
                <Avatar
                    size="m"
                    src="https://avatars.mds.yandex.net/get-pdb/881477/2398e88e-e017-49bd-94cc-8fec35e73f64/s1200"
                />
            }
        />
    </Box>
);
NewPaymentHeader.parameters = {
    info: {
        comment:
            'Заголовок на странице оплаты. Содержит логотип и аватар пользователя',
    },
};
