import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import YandexTravelLogo from 'components/YandexTravelLogo/YandexTravelLogo';
import Separator from 'components/Separator/Separator';

import cx from './PaymentHeader.scss';

interface IPaymentHeaderProps extends IWithClassName {
    rightSide?: React.ReactNode;
    noLogo?: boolean;
}

const PaymentHeader: React.FC<IPaymentHeaderProps> = props => {
    const {className, rightSide = null, noLogo = false} = props;

    const deviceType = useDeviceType();

    return (
        <div
            className={cx(className, 'root', {
                root_ie: deviceType.isIe,
                root_noLogo: noLogo,
            })}
        >
            {!noLogo && (
                <>
                    <YandexTravelLogo withYandexLogo withoutLinks />
                    <Separator className={cx('separator')} />
                </>
            )}
            <div className={cx('rightSide')}>{rightSide}</div>
        </div>
    );
};

export default PaymentHeader;
