import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Checkbox from 'components/Checkbox/Checkbox';
import PaymentHeader from './components/PaymentHeader/PaymentHeader';
import PaymentOrderInfo from './components/PaymentOrderInfo/PaymentOrderInfo';

import PaymentLayout from './PaymentLayout';

export default {
    title: 'Example/Layout/Payment',
    component: PaymentLayout,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <PaymentLayout
        header={<PaymentHeader orderNumber="73946833037374" />}
        footer={
            <Checkbox
                size="s"
                checked
                label="Согласен получать новости и выгодные предложения Яндекс.Путешествий"
            />
        }
        orderInfo={
            <PaymentOrderInfo
                title="Оплата заказа на сумму 3 600 ₽"
                details={[
                    [
                        '9 ноября – 10 ноября',
                        '9 гостей',
                        'Апартаменты Chalet With 5 Bedrooms in Cogollos de Guadix',
                    ],
                ]}
                advantages={[
                    'Бесплатная отмена до 10 октября 2020',
                    'Сопровождаем ваше бронирование до заселения',
                ]}
            />
        }
    >
        <div
            style={{
                height: 400,
                display: 'flex',
                alignItems: 'center',
                justifyContent: 'center',
                backgroundColor: '#b0c7ee',
            }}
        >
            Payment frame
        </div>
    </PaymentLayout>
);
