import React from 'react';

import {IWithClassName} from 'types/withClassName';

import TextWithIcon from 'components/TextWithIcon/TextWithIcon';
import CheckCircleIcon from 'icons/16/CheckCircle';

import cx from './PaymentAdvantage.scss';

interface IPaymentAdvantageProps extends IWithClassName {
    children: React.ReactNode;
}

const PaymentAdvantage: React.FC<IPaymentAdvantageProps> = ({
    children,
    className,
}) => {
    return (
        <TextWithIcon
            className={className}
            text={children}
            iconLeft={CheckCircleIcon}
            iconLeftClassName={cx('icon')}
        />
    );
};

export default PaymentAdvantage;
