import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Text from 'components/Text/Text';

interface IPaymentTitleProps extends IWithClassName {
    children: React.ReactNode;
}

const PaymentTitle: React.FC<IPaymentTitleProps> = props => {
    const {className, children} = props;
    const deviceType = useDeviceType();

    return (
        <div className={className}>
            <Text weight="bold" size={deviceType.isMobile ? 'l' : 'xl'}>
                {children}
            </Text>
        </div>
    );
};

export default PaymentTitle;
