import React from 'react';
import {IntersectionOptions, useInView} from 'react-intersection-observer';

interface ILazyComponentProps {
    renderContent(): React.ReactElement;
    intersectionObserverOptions?: IntersectionOptions;
    renderPlaceholder?(
        ref: (node?: Element | null) => void,
    ): React.ReactElement;
}

const INTERSECTION_OBSERVER_DEFAULT_OPTIONS = {
    triggerOnce: true,
};

const LazyComponent: React.FC<ILazyComponentProps> = props => {
    const {renderContent, intersectionObserverOptions, renderPlaceholder} =
        props;

    const [ref, inView] = useInView({
        ...INTERSECTION_OBSERVER_DEFAULT_OPTIONS,
        ...intersectionObserverOptions,
    });

    if (!inView) {
        if (renderPlaceholder) {
            return renderPlaceholder(ref);
        }

        return <div ref={ref} />;
    }

    return renderContent();
};

export default React.memo(LazyComponent);
