import {FC} from 'react';
import {composeU} from '@bem-react/core';

import {
    Link as LegoLink,
    ILinkProps as ILegoLinkProps,
    withThemeNormal,
    withThemeBlack,
    withThemeGhost,
    withThemePseudo,
    withThemeOuter,
    cnLink,
    withViewDefault,
} from '@yandex-lego/components/Link/desktop';

const YTLegoLinkWrapper: FC<ILegoLinkProps> = props => {
    const {className, ...rest} = props;

    return <LegoLink {...rest} className={cnLink(null, [className])} />;
};

export const LegoLinkPresenter = composeU(
    withThemeNormal,
    withThemeBlack,
    withThemeGhost,
    withThemePseudo,
    withThemeOuter,
    withViewDefault,
)(YTLegoLinkWrapper);
