import React from 'react';
import moment from 'moment-timezone';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {HUMAN, ROBOT} from 'utilities/dateUtils/formats';

import * as i18nBlock from 'i18nNew/LinkBackward';

import BackwardIcon from 'icons/16/Backward';
import Link from 'components/Link/Link';
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';

interface ILinkBackwardProps extends IWithClassName, IWithQaAttributes {
    title?: string;
    date?: string;
    to: string;
    onClick?(): void;
}

const LinkBackward: React.FC<ILinkBackwardProps> = props => {
    const {className, date, to, onClick} = props;
    const formattedDate = date
        ? moment(date, ROBOT).format(HUMAN).toLowerCase()
        : '';
    const title = props.title || i18nBlock.text({date: formattedDate});

    return (
        <Link
            className={className}
            to={to}
            rel="noopener noreferrer"
            target="_blank"
            theme="normal"
            onClick={onClick}
            {...prepareQaAttributes({parent: props, current: 'linkBackward'})}
        >
            <TextWithIcon text={title} iconLeft={BackwardIcon} size="s" />
        </Link>
    );
};

export default React.memo(LinkBackward);
