import React from 'react';

import LinkBreadcrumbsItem, {
    TLinkBreadcrumbsItemProps,
} from '../components/LinkBreadcrumbsItem/LinkBreadcrumbsItem';

// prettier-ignore
const LinkBreadcrumbItemType = (<LinkBreadcrumbsItem />).type;

export default function isLinkBreadcrumbsItem(
    x: unknown,
): x is React.ReactElement<TLinkBreadcrumbsItemProps> {
    if (typeof x === 'object' && React.isValidElement(x)) {
        return x.type === LinkBreadcrumbItemType;
    }

    return false;
}
