import {Meta} from '@storybook/react/types-6-0';
import {noop} from 'lodash';

import {TStorybookFunctionComponent} from 'storybook/types';

import {TLinkThemeType} from 'components/Link/Link';
import StyleguidistPropTable from 'components/StyleguidistPropTable/StyleguidistPropTable';

import LinkButton from './LinkButton';

export default {
    title: 'Example/LinkButton',
    component: LinkButton,
} as Meta;

const THEMES: TLinkThemeType[] = ['normal', 'black', 'ghost', 'outer', 'brand'];

export const Simple: TStorybookFunctionComponent = () => (
    <StyleguidistPropTable
        props={THEMES.map(theme => ({
            name: theme,
            props: {theme},
            example: (
                <LinkButton theme={theme} text="Find out more" onClick={noop} />
            ),
        }))}
    />
);
