import React, {FunctionComponent} from 'react';

import Link, {ILegoLinkProps} from 'components/Link/Link';

interface ILinkButtonProps extends Omit<ILegoLinkProps, 'url'> {
    onMouseEnter?(event: React.MouseEvent): void;
    onMouseLeave?(event: React.MouseEvent): void;
    onClick?(event: React.MouseEvent): void;
}

/**
 * Компонент кнопок, которые отрисовываются как ссылки.
 * Принимает те же пропсы что и LegoLink за исключением url
 */
const LinkButton: FunctionComponent<ILinkButtonProps> = props => {
    return <Link {...props} url="" />;
};

export default LinkButton;
