import React, {ReactNode} from 'react';
import {
    default as VendorMaskedInput,
    MaskedInputProps as VendorMaskedInputProps,
} from 'react-text-mask';

import {IInputProps} from 'components/Input/types/InputProps';

import Input from 'components/Input/Input';

export interface IMaskedInputProps
    extends IInputProps,
        Pick<
            VendorMaskedInputProps,
            | 'mask'
            | 'pipe'
            | 'showMask'
            | 'placeholderChar'
            | 'keepCharPositions'
        > {}

export class MaskedInput extends React.Component<IMaskedInputProps> {
    static readonly defaultProps: IMaskedInputProps = {
        placeholderChar: '_',
        keepCharPositions: false,
    };

    private inputRef: HTMLInputElement | null = null;

    private refInput = (input: HTMLInputElement | null): void => {
        this.inputRef = input;

        if (this.props.inputRef) {
            this.props.inputRef(input);
        }
    };

    private handleChange = (): void => {
        if (this.props.onChange && this.inputRef) {
            this.props.onChange({target: this.inputRef}, this.inputRef.value);
        }
    };

    render(): ReactNode {
        const {
            mask,
            pipe,
            showMask,
            placeholderChar,
            keepCharPositions,
            inputRef,
            onChange,
            ...inputProps
        } = this.props;

        return (
            <VendorMaskedInput
                mask={mask}
                placeholderChar={placeholderChar || undefined}
                showMask={showMask}
                guide={Boolean(placeholderChar)}
                onChange={this.handleChange}
                value={inputProps.value}
                pipe={pipe}
                keepCharPositions={keepCharPositions}
                render={(ref, {onBlur, ...props}): ReactNode => (
                    <Input
                        {...inputProps}
                        {...props}
                        value={undefined}
                        inputRef={(input: HTMLInputElement): void => {
                            ref(input);
                            this.refInput(input);
                        }}
                    />
                )}
            />
        );
    }
}

export default MaskedInput;
