import {useState, useRef} from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import CheckButton from 'components/CheckButton/CheckButton';

import MessageBoxPopup, {EMessageBoxPopupTheme} from './MessageBoxPopup';

export default {
    title: 'Example/MessageBoxPopup',
    component: MessageBoxPopup,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    const [checked, setChecked] = useState(false);
    const anchorRef = useRef<HTMLDivElement | null>(null);
    const scopeRef = useRef<HTMLDivElement | null>(null);

    return (
        <div className="container" ref={scopeRef}>
            <CheckButton
                checked={checked}
                onClick={(): void => setChecked(!checked)}
                innerRef={anchorRef}
            >
                Toggle Popup
            </CheckButton>
            <MessageBoxPopup
                isVisible={checked}
                anchorRef={anchorRef}
                onClose={(): void => setChecked(false)}
            >
                <div style={{padding: '25px'}}>
                    <div>
                        As we go through life we gradually discover who we are,
                        but the more we discover, the more we lose ourselves.
                    </div>
                </div>
            </MessageBoxPopup>

            <div style={{margin: '30px'}}>
                - Haruki Murakami, Colorless Tsukuru Tazaki and His Years of
                Pilgrimage
            </div>
        </div>
    );
};

export const White: TStorybookFunctionComponent = () => {
    const [checked, setChecked] = useState(false);
    const anchorRef = useRef<HTMLDivElement | null>(null);
    const scopeRef = useRef<HTMLDivElement | null>(null);

    return (
        <div className="container" ref={scopeRef}>
            <CheckButton
                checked={checked}
                onClick={(): void => setChecked(!checked)}
                innerRef={anchorRef}
            >
                Toggle White Popup
            </CheckButton>
            <MessageBoxPopup
                theme={EMessageBoxPopupTheme.WHITE}
                isVisible={checked}
                anchorRef={anchorRef}
                onClose={(): void => setChecked(false)}
            >
                <div style={{padding: '25px'}}>
                    <div>Этот Tooltip белого цвета</div>
                </div>
            </MessageBoxPopup>

            <div style={{margin: '30px'}}>
                Tooltip белого цвета, нажми на кнопку
            </div>
        </div>
    );
};

export const ArrowBug: TStorybookFunctionComponent = () => {
    const [checked, setChecked] = useState(false);
    const anchorRef = useRef<HTMLDivElement | null>(null);

    return (
        <div>
            <p>Кликни ниже А</p>
            <span onClick={(): void => setChecked(!checked)} ref={anchorRef}>
                A
            </span>
            <MessageBoxPopup
                isVisible={checked}
                anchorRef={anchorRef}
                onClose={(): void => setChecked(false)}
            >
                <div style={{margin: '30px'}}>
                    Стрелочка отрисовывается пока не там, где нужно. Нужно
                    обновить lego.
                </div>
            </MessageBoxPopup>
        </div>
    );
};
