import {useState} from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Button from 'components/Button/Button';

import MessageBoxPopupOrBottomSheet from './MessageBoxPopupOrBottomSheet';

export default {
    title: 'Example/MessageBoxPopupOrBottomSheet',
    component: MessageBoxPopupOrBottomSheet,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    const [isVisible, setVisibility] = useState(false);

    return (
        <>
            <Button onClick={(): void => setVisibility(true)}>Open</Button>
            <MessageBoxPopupOrBottomSheet
                isVisible={isVisible}
                onClose={(): void => setVisibility(false)}
            >
                Какое-то содержимое
            </MessageBoxPopupOrBottomSheet>
        </>
    );
};

Simple.parameters = {
    info: {
        title: 'Попап или выезжающее окно снизу в зависимости от устройства',
    },
};
