import {useState} from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Box from 'components/Box/Box';
import Button from 'components/Button/Button';
import Heading from 'components/Heading/Heading';

import Modal from './Modal';

export default {
    title: 'Example/Modal',
    component: Modal,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    const [isVisible, setVisibility] = useState(false);
    const deviceType = useDeviceType();

    return (
        <>
            <button onClick={(): void => setVisibility(true)}>
                Open Modal
            </button>
            <Modal
                onClose={(): void => setVisibility(false)}
                isVisible={isVisible}
                isMobile={deviceType.isMobile}
            >
                <Modal.Content>
                    <div
                        style={{
                            minHeight: 100,
                            backgroundColor: '#e6e6e6',
                        }}
                    >
                        <Heading level="1">
                            Focus must never leave modal
                        </Heading>
                        <button>1</button>
                        <button>2</button>
                        <button>3</button>
                        <button>4</button>
                    </div>
                </Modal.Content>
            </Modal>
        </>
    );
};

export const BigContent: TStorybookFunctionComponent = () => {
    const [isVisible, setVisibility] = useState(false);
    const deviceType = useDeviceType();

    return (
        <>
            <button onClick={(): void => setVisibility(true)}>
                Open Modal
            </button>
            <Modal
                onClose={(): void => setVisibility(false)}
                isVisible={isVisible}
                isMobile={deviceType.isMobile}
                hasCloseButton
            >
                <Modal.Content>
                    <div
                        style={{
                            minHeight: 100,
                            backgroundColor: '#e6e6e6',
                        }}
                    >
                        <Heading level="1">
                            Focus must never leave modal
                        </Heading>
                        <span>
                            Тут очень много какого-то текст. Так много, что бы
                            на экран мобильного устройства не влезло. А
                            прокрутка документа запрещена. Тут очень много
                            какого-то текст. Так много, что бы на экран
                            мобильного устройства не влезло. А прокрутка
                            документа запрещена. Тут очень много какого-то
                            текст. Так много, что бы на экран мобильного
                            устройства не влезло. А прокрутка документа
                            запрещена. Тут очень много какого-то текст. Так
                            много, что бы на экран мобильного устройства не
                            влезло. А прокрутка документа запрещена. Тут очень
                            много какого-то текст. Так много, что бы на экран
                            мобильного устройства не влезло. А прокрутка
                            документа запрещена. Тут очень много какого-то
                            текст. Так много, что бы на экран мобильного
                            устройства не влезло. А прокрутка документа
                            запрещена. Тут очень много какого-то текст. Так
                            много, что бы на экран мобильного устройства не
                            влезло. А прокрутка документа запрещена. Тут очень
                            много какого-то текст. Так много, что бы на экран
                            мобильного устройства не влезло. А прокрутка
                            документа запрещена. Тут очень много какого-то
                            текст. Так много, что бы на экран мобильного
                            устройства не влезло. А прокрутка документа
                            запрещена. Тут очень много какого-то текст. Так
                            много, что бы на экран мобильного устройства не
                            влезло. А прокрутка документа запрещена. Тут очень
                            много какого-то текст. Так много, что бы на экран
                            мобильного устройства не влезло. А прокрутка
                            документа запрещена. Тут очень много какого-то
                            текст. Так много, что бы на экран мобильного
                            устройства не влезло. А прокрутка документа
                            запрещена. Тут очень много какого-то текст. Так
                            много, что бы на экран мобильного устройства не
                            влезло. А прокрутка документа запрещена. Тут очень
                            много какого-то текст. Так много, что бы на экран
                            мобильного устройства не влезло. А прокрутка
                            документа запрещена. Тут очень много какого-то
                            текст. Так много, что бы на экран мобильного
                            устройства не влезло. А прокрутка документа
                            запрещена. Тут очень много какого-то текст. Так
                            много, что бы на экран мобильного устройства не
                            влезло. А прокрутка документа запрещена. Тут очень
                            много какого-то текст. Так много, что бы на экран
                            мобильного устройства не влезло. А прокрутка
                            документа запрещена. Тут очень много какого-то
                            текст. Так много, что бы на экран мобильного
                            устройства не влезло. А прокрутка документа
                            запрещена. Тут очень много какого-то текст. Так
                            много, что бы на экран мобильного устройства не
                            влезло. А прокрутка документа запрещена. Тут очень
                            много какого-то текст. Так много, что бы на экран
                            мобильного устройства не влезло. А прокрутка
                            документа запрещена. Тут очень много какого-то
                            текст. Так много, что бы на экран мобильного
                            устройства не влезло. А прокрутка документа
                            запрещена. Тут очень много какого-то текст. Так
                            много, что бы на экран мобильного устройства не
                            влезло. А прокрутка документа запрещена. Тут очень
                            много какого-то текст. Так много, что бы на экран
                            мобильного устройства не влезло. А прокрутка
                            документа запрещена. Тут очень много какого-то
                            текст. Так много, что бы на экран мобильного
                            устройства не влезло. А прокрутка документа
                            запрещена.
                        </span>
                    </div>
                </Modal.Content>
            </Modal>
        </>
    );
};

export const VerticalAlignTop: TStorybookFunctionComponent = () => {
    const [isVisible, setVisibility] = useState(false);
    const deviceType = useDeviceType();

    return (
        <>
            <button onClick={(): void => setVisibility(true)}>
                Open Modal
            </button>
            <Modal
                onClose={(): void => setVisibility(false)}
                isVisible={isVisible}
                verticalAlign="top"
                isMobile={deviceType.isMobile}
            >
                <Modal.Content>
                    <div
                        style={{
                            minHeight: 100,
                            width: 1000,
                            backgroundColor: '#e6e6e6',
                        }}
                    >
                        <Heading level="1">
                            Focus must never leave modal
                        </Heading>
                        <button>1</button>
                        <button>2</button>
                        <button>3</button>
                        <button>4</button>
                    </div>
                </Modal.Content>
            </Modal>
        </>
    );
};

export const VerticalAlignBottom: TStorybookFunctionComponent = () => {
    const [isVisible, setVisibility] = useState(false);
    const deviceType = useDeviceType();

    return (
        <>
            <button onClick={(): void => setVisibility(true)}>
                Open Modal
            </button>
            <Modal
                onClose={(): void => setVisibility(false)}
                isVisible={isVisible}
                verticalAlign="bottom"
                isMobile={deviceType.isMobile}
            >
                <Modal.Content>
                    <div
                        style={{
                            minHeight: 100,
                            width: 1000,
                            backgroundColor: '#e6e6e6',
                        }}
                    >
                        <Heading level="1">
                            Focus must never leave modal
                        </Heading>
                        <button>1</button>
                        <button>2</button>
                        <button>3</button>
                        <button>4</button>
                    </div>
                </Modal.Content>
            </Modal>
        </>
    );
};

export const Fullscreen: TStorybookFunctionComponent = () => {
    const [isVisible, setVisibility] = useState(false);
    const deviceType = useDeviceType();

    return (
        <>
            <button onClick={(): void => setVisibility(true)}>
                Open Modal
            </button>
            <Modal
                onClose={(): void => setVisibility(false)}
                isVisible={isVisible}
                verticalAlign="bottom"
                isMobile={deviceType.isMobile}
                fullScreen
            >
                <Box inset="4">
                    <button onClick={(): void => setVisibility(false)}>
                        {'<'} back to docs
                    </button>
                </Box>
                <div
                    style={{
                        minHeight: 1000,
                        backgroundColor: '#e6e6e6',
                    }}
                >
                    <Modal.Content>
                        <Heading level="1">
                            Focus must never leave modal
                        </Heading>
                        <button>1</button>
                        <button>2</button>
                        <button>3</button>
                        <button>4</button>
                    </Modal.Content>
                </div>
            </Modal>
        </>
    );
};

export const DisableAnimation: TStorybookFunctionComponent = () => {
    const [isVisible, setVisibility] = useState(false);
    const deviceType = useDeviceType();

    return (
        <>
            <button onClick={(): void => setVisibility(true)}>
                Open Modal
            </button>
            <Modal
                onClose={(): void => setVisibility(false)}
                isVisible={isVisible}
                isMobile={deviceType.isMobile}
                disableAnimations
            >
                <Modal.Content>
                    <div
                        style={{
                            minHeight: 100,
                            width: 1000,
                            backgroundColor: '#e6e6e6',
                        }}
                    >
                        <Heading level="1">
                            Focus must never leave modal
                        </Heading>
                        <button>1</button>
                        <button>2</button>
                        <button>3</button>
                        <button>4</button>
                    </div>
                </Modal.Content>
            </Modal>
        </>
    );
};

export const PreventBodyScroll: TStorybookFunctionComponent = () => {
    const [isVisible, setVisibility] = useState(false);
    const deviceType = useDeviceType();

    return (
        <>
            <button onClick={(): void => setVisibility(true)}>
                Open Modal
            </button>
            <Modal
                onClose={(): void => setVisibility(false)}
                isVisible={isVisible}
                isMobile={deviceType.isMobile}
                disableAnimations
            >
                <Modal.Content>
                    <div
                        style={{
                            minHeight: 200,
                            width: 1000,
                            backgroundColor: '#e6e6e6',
                        }}
                    >
                        <Heading level="1">
                            Scroll Text, bu not scroll Body
                        </Heading>
                        <div
                            style={{
                                overflowY: 'scroll',
                                height: '100px',
                                width: '100px',
                            }}
                        >
                            {' '}
                            Many, many words for getting scroll! Many, many
                            words for getting scroll! Many, many words for
                            getting scroll! Many, many words for getting scroll!
                            Many, many words for getting scroll! Many, many
                            words for getting scroll! Many, many words for
                            getting scroll! Many, many words for getting scroll!{' '}
                        </div>
                    </div>
                </Modal.Content>
            </Modal>
        </>
    );
};

export const CustomClose: TStorybookFunctionComponent = () => {
    const [isVisible, setVisibility] = useState(false);
    const deviceType = useDeviceType();

    return (
        <>
            <button onClick={(): void => setVisibility(true)}>
                Open Modal
            </button>
            <Modal
                isVisible={isVisible}
                isMobile={deviceType.isMobile}
                autoclosable={false}
                hasCloseButton={false}
            >
                <Modal.Content>
                    <div
                        style={{
                            minHeight: 200,
                            width: 1000,
                            backgroundColor: '#e6e6e6',
                        }}
                    >
                        <Heading level="1">
                            No autoclose and default close button
                        </Heading>
                        <Button
                            theme="primary"
                            onClick={(): void => setVisibility(false)}
                        >
                            Закрыть
                        </Button>
                    </div>
                </Modal.Content>
            </Modal>
        </>
    );
};
