import React from 'react';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Modal, {IModalContentProps, IModalProps} from 'components/Modal/Modal';
import BottomSheet, {
    IBottomSheetProps,
} from 'components/BottomSheet/BottomSheet';

interface IModalOrBottomSheetProps {
    children: React.ReactNode;
    isVisible: boolean;
    modalProps?: Omit<IModalProps, 'children' | 'isVisible' | 'onClose'>;
    modalContentProps?: IModalContentProps;
    bottomSheetProps?: Omit<
        IBottomSheetProps,
        'children' | 'isOpened' | 'onClose'
    >;
    onClose(): void;
}

const ModalOrBottomSheet: React.FC<IModalOrBottomSheetProps> = props => {
    const {
        children,
        isVisible,
        modalProps,
        modalContentProps,
        bottomSheetProps,
        onClose,
    } = props;
    const deviceType = useDeviceType();

    if (deviceType.isDesktop) {
        return (
            <Modal {...modalProps} isVisible={isVisible} onClose={onClose}>
                <Modal.Content {...modalContentProps}>{children}</Modal.Content>
            </Modal>
        );
    }

    return (
        <BottomSheet
            {...bottomSheetProps}
            isOpened={isVisible}
            onClose={onClose}
        >
            {children}
        </BottomSheet>
    );
};

export default ModalOrBottomSheet;
