import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';
import Link from 'components/Link/Link';

interface IActiveTripsListItemProps extends IWithClassName, IWithQaAttributes {
    trip: any;
    onClick?(): void;
}

const ActiveTripsListItem: React.FC<IActiveTripsListItemProps> = props => {
    const {className, trip, onClick} = props;

    return (
        <Link
            className={className}
            to={''}
            onClick={onClick}
            {...prepareQaAttributes(props)}
        >
            <Flex between={3} inline alignItems="center" nowrap>
                <Text
                    size="m"
                    overflow="ellipsis"
                    {...prepareQaAttributes({parent: props, current: 'title'})}
                >
                    {trip.title}
                </Text>
            </Flex>
        </Link>
    );
};

export default ActiveTripsListItem;
