import React from 'react';

import {PLUS_BONUS_POINTS_PERCENTAGE} from 'constants/plus';

import {TUserInfo} from 'reducers/common/commonReducerTypes';

import * as accountI18nBlock from 'i18nNew/account';

import Text from 'components/Text/Text';
import PlusColoredLabel from 'components/PlusColoredLabel/PlusColoredLabel';

import cx from './PlusInfo.scss';

export interface IPlusInfoProps {
    userInfo: TUserInfo;
}

const PlusInfo: React.FC<IPlusInfoProps> = props => {
    const {userInfo} = props;
    const plusUserInfo = userInfo.plusInfo;
    const hasPlus = plusUserInfo?.hasPlus ?? false;
    const points = plusUserInfo?.points ?? 0;

    return (
        <div className={cx('plusInfo')}>
            {hasPlus ? (
                <>
                    <Text className={cx('plusHeader')} weight="bold" size="m">
                        {accountI18nBlock.plus()}
                    </Text>
                    <PlusColoredLabel
                        className={cx('plusIcon')}
                        count={points}
                    />
                    <div>
                        {points
                            ? accountI18nBlock.plusDotCanUseV2()
                            : accountI18nBlock.plusDotHowToObtain()}
                    </div>
                </>
            ) : (
                <>
                    <Text className={cx('plusHeader')} weight="bold" size="m">
                        {accountI18nBlock.plusDotConnect()}
                    </Text>
                    <PlusColoredLabel
                        className={cx('plusIcon')}
                        label={PLUS_BONUS_POINTS_PERCENTAGE}
                    />
                    <div>{accountI18nBlock.plusDotWhyShouldConnectV2()}</div>
                </>
            )}
        </div>
    );
};

export default PlusInfo;
