import React from 'react';

import {URLs} from 'constants/urls';

import {useMobile} from 'utilities/hooks/useMobile';

import * as i18nBlock from 'i18nNew/common-notFoundPage';

import ButtonLink from 'components/ButtonLink/ButtonLink';

import cx from './NotFoundContent.scss';

const NotFoundContent: React.FC = () => {
    const isMobile = useMobile();

    return (
        <div className={cx('root', {root_mobile: isMobile})}>
            <div className={cx('wrapper', {wrapper_mobile: isMobile})}>
                <div className={cx('content')}>
                    <h2 className={cx('title')}>{i18nBlock.pageDashTitle()}</h2>

                    <div className={cx('description')}>
                        <div className={cx('text')}>
                            {i18nBlock.description()}
                        </div>

                        <div
                            className={cx('text')}
                            dangerouslySetInnerHTML={{
                                __html: i18nBlock.helpDashDescription(),
                            }}
                        />
                    </div>

                    <div className={cx('buttons')}>
                        <ButtonLink
                            className={cx('button')}
                            size={isMobile ? 'l' : 's'}
                            url={URLs.account}
                        >
                            {i18nBlock.toDashAccount()}
                        </ButtonLink>

                        <ButtonLink
                            className={cx('button')}
                            theme="primary"
                            size={isMobile ? 'l' : 's'}
                            url={URLs.index}
                        >
                            {i18nBlock.toDashHome()}
                        </ButtonLink>
                    </div>
                </div>
            </div>
        </div>
    );
};

export default NotFoundContent;
