import React, {Component} from 'react';
import Helmet from 'react-helmet';

import {ECommonGoal} from 'utilities/metrika/types/goals/common';

import {reachGoal} from 'utilities/metrika';

import * as i18nBlock from 'i18nNew/common-notFoundPage';

import NotFoundStatus from './components/NotFoundStatus/NotFoundStatus';

interface NotFoundWrapperPropTypes {
    children: React.ReactNode;
}

class NotFoundWrapper extends Component<NotFoundWrapperPropTypes> {
    componentDidMount() {
        reachGoal(ECommonGoal.PAGE_404_SHOW);
    }

    render() {
        return (
            <NotFoundStatus>
                <Helmet>
                    <title>{i18nBlock.metaDashTitle()}</title>
                </Helmet>

                {this.props.children}
            </NotFoundStatus>
        );
    }
}

export default NotFoundWrapper;
