import React, {Component} from 'react';
import {Route, RouteComponentProps} from 'react-router-dom';

const NOT_FOUND_STATUS_CODE = 404;

interface NotFoundStatusPropTypes {}

export default class NotFoundStatus extends Component<NotFoundStatusPropTypes> {
    private routeRenderer = ({
        staticContext,
    }: RouteComponentProps): React.ReactNode => {
        if (staticContext) {
            staticContext.statusCode = NOT_FOUND_STATUS_CODE;
        }

        return this.props.children;
    };

    render(): React.ReactNode {
        return <Route render={this.routeRenderer} />;
    }
}
