import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import NotificationBanner from 'components/NotificationBanner/NotificationBanner';
import Box from 'components/Box/Box';

export default {
    title: 'Example/NotificationBanner',
    component: NotificationBanner,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <Box inset={10}>
        <NotificationBanner>
            Найдены маршруты только с пересадками.
        </NotificationBanner>
    </Box>
);
Simple.parameters = {
    info: {
        title: 'Баннер с уведомлениями, одно уведомление',
    },
};

export const Multiple: TStorybookFunctionComponent = () => (
    <Box inset={10}>
        <NotificationBanner>
            {[
                'Страхование жизни и здоровья от несчастных случаев. Подробнее об условиях.',
                'Найдены маршруты только с пересадками.',
            ]}
        </NotificationBanner>
    </Box>
);
Multiple.parameters = {
    info: {
        title: 'Баннер с уведомлениями, несколько уведомлений',
    },
};
