import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import StyleguidistSizeTable from 'components/StyleguidistSizeTable/StyleguidistSizeTable';
import HeartOutline16Icon from 'icons/16/HeartOutline';
import HeartOutline24Icon from 'icons/24/HeartOutline';
import HeartOutline36Icon from 'icons/36/HeartOutline';

import NotificationDot from './NotificationDot';

export default {
    title: 'Example/NotificationDot',
    component: NotificationDot,
} as Meta;

const SIZES = [
    {name: 's' as const, size: '16px', icon: HeartOutline16Icon},
    {name: 'm' as const, size: '24px', icon: HeartOutline24Icon},
    {name: 'l' as const, size: '36px', icon: HeartOutline36Icon},
];

export const Simple: TStorybookFunctionComponent = () => {
    return (
        <div style={{backgroundColor: 'white'}}>
            <NotificationDot size="m" dotVisible>
                <HeartOutline16Icon />
            </NotificationDot>
        </div>
    );
};

Simple.parameters = {
    info: {
        comment: 'Компонент работает только на белом фоне, ',
    },
};

export const Sizes: TStorybookFunctionComponent = () => {
    return (
        <StyleguidistSizeTable
            sizes={SIZES.map(({size, name, icon: Icon}) => ({
                size,
                name,
                example: (
                    <NotificationDot size={name} dotVisible>
                        <Icon />
                    </NotificationDot>
                ),
            }))}
        />
    );
};
