import {URLs} from 'constants/urls';

import {EAccountGoal} from 'utilities/metrika/types/goals/account';

import {getTripUrl} from 'projects/account/utilities/urls/getTripUrl';
import {reachGoal} from 'utilities/metrika';

import * as i18nBlock from 'i18nNew/account-OrderHeader';

interface IBackLinkInfo {
    url: string;
    text: string;
    handleClick?(): void;
}

export function getBackLinkInfo(tripId?: string | null): IBackLinkInfo {
    if (tripId) {
        return {
            url: getTripUrl(tripId),
            text: i18nBlock.backTrip(),
            handleClick(): void {
                reachGoal(EAccountGoal.BACK_LINK_TO_TRIP_CLICK);
            },
        };
    }

    return {
        url: URLs.accountTrips,
        text: i18nBlock.backTrips(),
        handleClick(): void {
            reachGoal(EAccountGoal.BACK_LINK_TO_TRIPS_CLICK);
        },
    };
}
