/* Структура пагинатора
 *
 * 1 - head
 * ... - headSeparator
 * 5 - body
 * 6 - body / фиксированная позиция выбранного элемента внутри body
 * 7 - body
 * 8 - body
 * 9 - body
 * ... - tailSeparator
 * 12 - tail
 */

export function getBodyPages(
    pages: number[],
    page: number,
    bodyLength: number,
): number[] {
    const outOfLimit = pages.length > bodyLength + 4;
    const showHeadSeparator = outOfLimit && page > 4;
    const showTailSeparator = outOfLimit && page < pages.length - bodyLength;

    return pages.slice(
        showHeadSeparator ? Math.min(pages.length - bodyLength, page) - 2 : 1,
        showTailSeparator
            ? Math.max(bodyLength + 2, page + bodyLength - 2)
            : -1,
    );
}
