import {useHistory} from 'react-router-dom';
import {useCallback, useEffect, useState} from 'react';
import {omit} from 'lodash';

import {internalUrl} from 'utilities/url';
import {useQueryByLocation} from 'utilities/hooks/useQueryByLocation';
import {validatePageNumber} from 'components/Pagination/utilities/validatePageNumber';

export function usePaginationWithHistory(
    paramName: string,
    minPageNumber: number,
    maxPageNumber: number,
): [number, (pageNumber: number) => void] {
    const history = useHistory();
    const query = useQueryByLocation();
    const pageNumberFromParams = validatePageNumber(
        query[paramName],
        minPageNumber,
        maxPageNumber,
    );
    const [page, setPage] = useState(pageNumberFromParams);

    // Отслеживаем изменение номера страницы в урле
    useEffect(() => {
        setPage(pageNumberFromParams);
    }, [pageNumberFromParams]);

    const handlePageChange = useCallback(
        (pageNumber: number) => {
            const validPageNumber = validatePageNumber(
                pageNumber,
                minPageNumber,
                maxPageNumber,
            );

            history.push(
                internalUrl(
                    location.pathname,
                    validPageNumber === 1
                        ? omit(query, [paramName])
                        : {
                              ...query,
                              [paramName]: validPageNumber,
                          },
                    {trailingSlash: true},
                ),
            );
        },
        [history, query, paramName, minPageNumber, maxPageNumber],
    );

    return [page, handlePageChange];
}
