import {FC, memo} from 'react';

import {IWithClassName} from 'types/withClassName';
import IPartnerRequisites from 'components/PartnersRequisites/types/IPartnerRequisites';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';
import {useBoolean} from 'utilities/hooks/useBoolean';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18nNew/trains-partners-requisites';

import ModalWithHistoryBack from 'containers/withSupportHistoryBack/ModalWithHistoryBack/ModalWithHistoryBack';

import LinkButton from 'components/LinkButton/LinkButton';
import Modal from 'components/Modal/Modal';
import PartnersInfo from 'components/PartnersRequisites/components/PartnersInfo/PartnersInfo';

interface IPartnersRequisitesProps extends IWithClassName, IWithQaAttributes {
    partners: IPartnerRequisites[];
}

const PartnersRequisites: FC<IPartnersRequisitesProps> = props => {
    const {className, partners} = props;

    const deviceType = useDeviceType();

    const {
        setTrue: handleOpen,
        setFalse: handleClose,
        value: isVisible,
    } = useBoolean(false);

    return (
        <div className={className} {...prepareQaAttributes(props)}>
            {insertJSXIntoKey(i18nBlock.dataDashDescription)({
                link: (
                    <LinkButton
                        onClick={handleOpen}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'openLink',
                        })}
                    >
                        {i18nBlock.partners()}
                    </LinkButton>
                ),
            })}

            <ModalWithHistoryBack
                isMobile={deviceType.isMobile}
                isVisible={isVisible}
                onClose={handleClose}
                {...prepareQaAttributes({parent: props, current: 'modal'})}
            >
                <Modal.Content>
                    <PartnersInfo
                        partners={partners}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'partnersInfo',
                        })}
                    />
                </Modal.Content>
            </ModalWithHistoryBack>
        </div>
    );
};

export default memo(PartnersRequisites);
