import React from 'react';

import {IWithClassName} from 'types/withClassName';
import IPartnerRequisites from 'components/PartnersRequisites/types/IPartnerRequisites';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Text from 'components/Text/Text';
import Flex from 'components/Flex/Flex';

import PartnerField from '../PartnerField/PartnerField';

interface IPartnerProps extends IWithClassName, IWithQaAttributes {
    partner: IPartnerRequisites;
}

const Partner: React.FC<IPartnerProps> = props => {
    const {className, partner} = props;
    const {title, fields} = partner;
    const deviceType = useDeviceType();

    return (
        <div className={className} {...prepareQaAttributes(props)}>
            <Text
                size={deviceType.isMobile ? 's' : 'l'}
                weight="bold"
                {...prepareQaAttributes({parent: props, current: 'title'})}
            >
                {title}
            </Text>

            <Flex above={2} flexDirection="column" between={2}>
                {fields.map((field, index) => (
                    <PartnerField
                        key={index}
                        {...field}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'partnerField',
                            key: index,
                        })}
                    />
                ))}
            </Flex>
        </div>
    );
};

export default Partner;
