import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import FieldLabel from 'components/FieldLabel/FieldLabel';

import cx from './PartnerField.scss';

interface IPartnerFieldProps extends IWithClassName, IWithQaAttributes {
    name: string;
    value: string;
}

const PartnerField: React.FC<IPartnerFieldProps> = props => {
    const {className, name, value} = props;
    const deviceType = useDeviceType();

    if (deviceType.isMobile) {
        return (
            <FieldLabel
                label={name}
                {...prepareQaAttributes({parent: props, current: 'fieldLabel'})}
            >
                {value}
            </FieldLabel>
        );
    }

    return (
        <div className={cx(className, 'root')} {...prepareQaAttributes(props)}>
            <div
                className={cx('name')}
                {...prepareQaAttributes({parent: props, current: 'name'})}
            >
                {name}
            </div>

            <div
                className={cx('value')}
                {...prepareQaAttributes({parent: props, current: 'value'})}
            >
                {value}
            </div>
        </div>
    );
};

export default PartnerField;
