import IRawPartnerData from 'projects/trains/components/TrainsOrderPage/PartnersRequisites/types/IRawPartnerData';
import IPartnerRequisites, {
    IPartnerField,
} from 'components/PartnersRequisites/types/IPartnerRequisites';
import {isNotUndefined} from 'types/utilities';

import * as i18n from 'i18nNew/trains-partners-requisites';

export default function preparePartner(
    partner: IRawPartnerData,
): IPartnerRequisites {
    const {
        title,
        additionalFieldName,
        additionalFieldNumber,
        factAddress,
        judicialAddress,
        time,
    } = partner;

    return {
        title,
        fields: [
            additionalFieldName && additionalFieldNumber
                ? {name: additionalFieldName, value: additionalFieldNumber}
                : undefined,
            ...getAddressFields(factAddress, judicialAddress),
            time ? {name: i18n.workDashTime(), value: time} : undefined,
        ].filter(isNotUndefined),
    };
}

function getAddressFields(
    factAddress: string | undefined,
    judicialAddress: string | undefined,
): (IPartnerField | undefined)[] {
    if (factAddress && factAddress === judicialAddress) {
        return [{name: i18n.address(), value: factAddress}];
    }

    return [
        factAddress
            ? {name: i18n.factDashAddress(), value: factAddress}
            : undefined,
        judicialAddress
            ? {name: i18n.judicialDashAddress(), value: judicialAddress}
            : undefined,
    ];
}
