import {useEffect} from 'react';

import {FINISH_PAYMENT_POST_MESSAGE} from 'components/Layouts/PaymentFinish/utilities/constants';

interface IParams {
    onFinishPayment: () => void;
}

/**
 * Обработка события которое отправляет наша служебная страница finishPayment
 */
export default function useCustomFinishPaymentEvent(params: IParams): void {
    useEffect(() => {
        const {onFinishPayment} = params;

        const handleChildrenPostMessage = (e: MessageEvent): void => {
            const {data} = e;

            /* Messages from YaTravel FinishPayment page*/
            if (data === FINISH_PAYMENT_POST_MESSAGE) {
                onFinishPayment();
            }
        };

        window.addEventListener('message', handleChildrenPostMessage, false);

        return (): void => {
            window.removeEventListener('message', handleChildrenPostMessage);
        };
    }, []);
}
