import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import StyleguidistSizeTable from 'components/StyleguidistSizeTable/StyleguidistSizeTable';

import PlusColoredLabel from './PlusColoredLabel';

export default {
    title: 'Example/PlusColoredLabel',
    component: PlusColoredLabel,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <PlusColoredLabel count={777} />
);

export const Sizes: TStorybookFunctionComponent = () => (
    <StyleguidistSizeTable
        sizes={[
            {
                name: 's',
                example: <PlusColoredLabel size="s" count={777} />,
            },
            {
                name: 'm',
                example: <PlusColoredLabel size="m" count={777} />,
            },
        ]}
    />
);
