import React, {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';

import YandexPlusSignWhiteS from 'icons/illustrations/YandexPlusSignWhite/YandexPlusSignWhiteS';

import cx from './PlusColoredLabel.scss';

export type TPlusLabelProps = IWithClassName & {
    size?: 's' | 'm';
} & (
        | {
              label: string;
              count?: never;
          }
        | {
              label?: never;
              count: number;
          }
    );

const PlusColoredLabel: FunctionComponent<TPlusLabelProps> = ({
    className,
    size = 'm',
    count,
    label,
}) => {
    const sizes: Record<TPlusLabelProps['size'] & string, number> = {
        s: 8,
        m: 12,
    };

    return (
        <div className={cx('root', `root_size_${size}`, className)}>
            <YandexPlusSignWhiteS
                className={cx('icon')}
                width={sizes[size]}
                height={sizes[size]}
            />
            <span className={cx('count')}>{count ?? label}</span>
        </div>
    );
};

export default React.memo(PlusColoredLabel);
