import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Flex from 'components/Flex/Flex';
import StyleguidistSizeTable from 'components/StyleguidistSizeTable/StyleguidistSizeTable';

import PlusInfoPopup from './PlusInfoPopup';

export default {
    title: 'Example/PlusInfoPopup',
    component: PlusInfoPopup,
} as Meta;

const fishText =
    'Страхование жизни и здоровья от несчастных случаев. Подробнее об условиях.';

export const Simple: TStorybookFunctionComponent = () => (
    <Flex inset={10} justifyContent="center">
        <PlusInfoPopup points={120}>{fishText}</PlusInfoPopup>
    </Flex>
);
Simple.parameters = {
    info: {
        title:
            'Компонент для отображения подробностей по плюсу, только для десктопа. ' +
            'В таче будет выведена только сама строка.',
    },
};

export const LabelSizes: TStorybookFunctionComponent = () => (
    <StyleguidistSizeTable
        sizes={[
            {
                name: 's',
                example: (
                    <PlusInfoPopup points={120} labelSize="s-inset">
                        {fishText}
                    </PlusInfoPopup>
                ),
            },
            {
                name: 'm',
                example: (
                    <PlusInfoPopup points={120} labelSize="m">
                        {fishText}
                    </PlusInfoPopup>
                ),
            },
        ]}
    />
);
