import React from 'react';

import YandexPlusSignColorGradientM from 'icons/illustrations/YandexPlusSignColorGradient/YandexPlusSignColorGradientM';
import YandexPlusSignColorGradientS from 'icons/illustrations/YandexPlusSignColorGradient/YandexPlusSignColorGradientS';
import {TIconSize} from 'components/TextWithIcon/TextWithIcon';
import {TSize} from 'components/PlusInfoPopup/PlusInfoPopup';

export const getIconBySize = (size: TSize): React.FunctionComponent => {
    switch (size) {
        case 's-inset':
            return YandexPlusSignColorGradientM;
        case 'm':
            return YandexPlusSignColorGradientS;
    }
};

export const getIconSize = (size: TSize): TIconSize => {
    switch (size) {
        case 's-inset':
            return 12;
        case 'm':
            return 16;
    }
};
