import React from 'react';

import {IWithClassName} from 'types/withClassName';

import PlusPoints from 'components/PlusPoints/PlusPoints';

import cx from './PlusModeBlockRadioItem.scss';

export interface IPlusModeBlockItemProps extends IWithClassName {
    title: string;
    isActive: boolean;
    plusPoints?: number;
    disabled?: boolean;
    isLoading?: boolean;
}

const PlusModeBlockRadioItem: React.FC<IPlusModeBlockItemProps> = props => {
    const {isActive, plusPoints, className, title, disabled, isLoading} = props;
    const theme = isActive ? 'colored' : 'black';

    return (
        <div className={cx('plusTab', className)}>
            {title}
            <PlusPoints
                className={cx('plusPoints')}
                count={isLoading ? '' : plusPoints || 0}
                theme={disabled ? 'disabled' : theme}
                weight="medium"
            />
        </div>
    );
};

export default PlusModeBlockRadioItem;
