import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import StyleguidistSizeTable from 'components/StyleguidistSizeTable/StyleguidistSizeTable';
import StyleguidistPropTable from 'components/StyleguidistPropTable/StyleguidistPropTable';

import PlusPoints from './PlusPoints';

export default {
    title: 'Example/PlusPoints',
    component: PlusPoints,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <PlusPoints count={777} />
);

export const Sizes: TStorybookFunctionComponent = () => (
    <StyleguidistSizeTable
        sizes={[
            {
                name: 's',
                example: <PlusPoints size="s" count={777} />,
            },
            {
                name: 'm',
                example: <PlusPoints size="m" count={777} />,
            },
        ]}
    />
);
Sizes.parameters = {
    info: {
        comment: 'size не влияет на размер шрифта, т.к. ',
    },
};

export const Theme: TStorybookFunctionComponent = () => (
    <StyleguidistPropTable
        props={[
            {
                name: 'colored',
                props: {theme: 'colored'},
                example: <PlusPoints theme="colored" count={777} />,
            },
            {
                name: 'black',
                props: {theme: 'black'},
                example: <PlusPoints theme="black" count={777} />,
            },
            {
                name: 'semi-colored',
                props: {theme: 'semi-colored'},
                example: <PlusPoints theme="black" count={777} />,
            },
            {
                name: 'disabled',
                props: {theme: 'disabled'},
                example: <PlusPoints theme="disabled" count={777} />,
            },
        ]}
    />
);
