import {useRef, useState} from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';
import EPopupDirection from 'components/Popup/types/EPopupDirection';

import CheckButton from 'components/CheckButton/CheckButton';

import Popup from './Popup';

export default {
    title: 'Example/Popup',
    component: Popup,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    const [checked, setChecked] = useState(false);
    const ref = useRef<HTMLElement | null>(null);

    return (
        <>
            <CheckButton
                checked={checked}
                onClick={(): void => setChecked(!checked)}
                innerRef={ref}
            >
                Toggle Popup
            </CheckButton>
            <Popup
                visible={checked}
                anchor={ref}
                style={{width: 300, padding: 20}}
                zIndex={2}
            >
                I live my life a quarter mile at a time. Nothing else matters:
                not the mortgage, not the store, not my team and all their
                bullshit. For those ten seconds or less, Im free.
            </Popup>
        </>
    );
};

const DIRECTIONS = [
    EPopupDirection.BOTTOM_LEFT,
    EPopupDirection.BOTTOM,
    EPopupDirection.BOTTOM_RIGHT,
    EPopupDirection.TOP_LEFT,
    EPopupDirection.TOP,
    EPopupDirection.TOP_RIGHT,
    EPopupDirection.RIGHT_TOP,
    EPopupDirection.RIGHT,
    EPopupDirection.RIGHT_BOTTOM,
    EPopupDirection.LEFT_TOP,
    EPopupDirection.LEFT,
    EPopupDirection.LEFT_BOTTOM,
];

export const Direction: TStorybookFunctionComponent = () => {
    const [checked, setChecked] = useState(false);
    const ref = useRef<HTMLDivElement | null>(null);

    return (
        <>
            <div
                style={{
                    border: '2px solid #d9d9d9',
                    borderRadius: 4,
                    width: 320,
                    height: 200,
                    lineHeight: 200 + 'px',
                    textAlign: 'center',
                }}
                ref={ref}
            >
                <CheckButton
                    checked={checked}
                    onClick={(): void => setChecked(!checked)}
                >
                    Toggle Popup
                </CheckButton>
            </div>
            {DIRECTIONS.map(direction => {
                return (
                    <Popup
                        visible={checked}
                        anchor={ref}
                        key={direction}
                        directions={[direction]}
                        style={{padding: 4}}
                    >
                        {direction}
                    </Popup>
                );
            })}
        </>
    );
};

Direction.parameters = {
    layout: 'centered',
};
