import React from 'react';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import BottomSheet, {
    IBottomSheetProps,
} from 'components/BottomSheet/BottomSheet';
import Popup, {IPopupProps} from 'components/Popup/Popup';

export interface IPopupOrBottomSheetProps {
    isVisible: boolean;
    popupProps: Omit<IPopupProps, 'children' | 'visible' | 'onClose'>;
    bottomSheetProps?: Omit<
        IBottomSheetProps,
        'children' | 'isOpened' | 'onClose'
    >;
    onClose?(): void;
}

const PopupOrBottomSheet: React.FC<IPopupOrBottomSheetProps> = ({
    popupProps,
    bottomSheetProps,
    isVisible,
    onClose,
    children,
}) => {
    const {isDesktop} = useDeviceType();

    if (isDesktop) {
        return (
            <Popup {...popupProps} visible={isVisible} onClose={onClose}>
                {children}
            </Popup>
        );
    }

    return (
        <BottomSheet
            {...bottomSheetProps}
            isOpened={isVisible}
            onClose={onClose}
        >
            {children}
        </BottomSheet>
    );
};

export default PopupOrBottomSheet;
