import React, {Component} from 'react';

import {URLs} from 'constants/urls';

import {IWithClassName} from 'types/withClassName';
import {IWithDeviceType} from 'types/withDeviceType';

import {reloadPage} from 'utilities/browser/reloadPage';

import * as i18nBlock from 'i18nNew/components-PortalServerError';

import Button from 'components/Button/Button';
import ButtonLink from 'components/ButtonLink/ButtonLink';

import cx from './PortalServerError.scss';

interface IPortalServerErrorProps extends IWithClassName, IWithDeviceType {}

class PortalServerError extends Component<IPortalServerErrorProps> {
    static readonly defaultProps = {
        className: '',
        deviceType: {},
    };

    private handleClickReloadButton = (): void => {
        reloadPage();
    };

    private renderTitle(): React.ReactNode {
        return <h2 className={cx('title')}>{i18nBlock.title()}</h2>;
    }

    private renderDescription(): React.ReactNode {
        return (
            <div className={cx('description')}>
                <div
                    className={cx('descriptionText')}
                    dangerouslySetInnerHTML={{
                        __html: i18nBlock.description(),
                    }}
                />
            </div>
        );
    }

    private renderButtons(): React.ReactNode {
        const {
            deviceType: {isMobile},
        } = this.props;

        return (
            <div className={cx('buttons')}>
                <Button
                    className={cx('button', 'reloadButton')}
                    onClick={this.handleClickReloadButton}
                    size={isMobile ? 'l' : 'm'}
                >
                    {i18nBlock.reloadButton()}
                </Button>

                <ButtonLink
                    className={cx('button')}
                    theme="primary"
                    size={isMobile ? 'l' : 'm'}
                    url={URLs.index}
                >
                    {i18nBlock.toIndexPage()}
                </ButtonLink>
            </div>
        );
    }

    render(): React.ReactNode {
        const {
            className,
            deviceType: {isMobile},
        } = this.props;

        return (
            <section
                className={cx('portalServerError', className, {
                    portalServerError_mobile: isMobile,
                })}
            >
                <div className={cx('content')}>
                    {this.renderTitle()}
                    {this.renderDescription()}
                    {this.renderButtons()}
                </div>
            </section>
        );
    }
}

export default PortalServerError;
