import React from 'react';

import {IWithClassName} from 'types/withClassName';

import ValueType from 'utilities/currency/ValueType';
import {CurrencyType} from 'utilities/currency/CurrencyType';
import {IWithQaAttributes} from 'utilities/qaAttributes/qaAttributes';
import {PriceConverter} from 'utilities/currency/priceConverter';

import {TextColor} from 'components/Text/Text';
import PriceWithoutConvertor from 'components/PriceWithoutConvertor/PriceWithoutConvertor';

export interface IPriceProps extends IWithClassName, IWithQaAttributes {
    /** Цвет */
    color?: TextColor;

    /** Цена */
    value: ValueType;

    /** Валюта */
    currency: CurrencyType;

    /** Показывать знак валюты */
    isCurrencyShown?: boolean;

    /**
     * Префикс "от"
     */
    isFrom?: boolean;

    /** Префикс "до" */
    isUpTo?: boolean;

    /** Не показывать цифры после запятой */
    isRound?: boolean;

    /** Примерная цена */
    isRoughly?: boolean;

    /** Префикс к цене */
    prefix?: string;
    prefixDelimiter?: string;

    /**
     * Нужно ли конвертировать валюту к национальной
     * Конвертация возможна только в случае наличия соответствующих данных
     */
    withConversion?: boolean;

    /** Постфикс к цене */
    postfix?: string;
}

const Price: React.FC<IPriceProps> = props => {
    const priceConverter = {} as PriceConverter;

    return <PriceWithoutConvertor priceConverter={priceConverter} {...props} />;
};

export default Price;
