import {useState} from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import PriceFilter from './PriceFilter';

export default {
    title: 'Example/PriceFilter',
    component: PriceFilter,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    const [values, setValues] = useState<[number, number]>([100, 400]);

    return (
        <PriceFilter
            values={values}
            rangeValues={[100, 400]}
            onChange={setValues}
        />
    );
};

Simple.parameters = {
    layout: 'padded',
};
