import React from 'react';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import cx from './ProgressBar.scss';

export interface IProgressBarProps {
    current: number;
    all: number;
    visible: boolean;
    fixed?: boolean;
    theme: 'blue' | 'yellow';
    contentClassName?: string;
}

export const ProgressBar: React.FC<IProgressBarProps> = ({
    all,
    current,
    fixed = true,
    visible,
    theme,
    contentClassName,
    children,
}) => {
    const deviceType = useDeviceType();
    const percent = Math.min(1, Math.max(0, current / all));

    return (
        <div
            className={cx(
                'root',
                visible && 'root_visible',
                fixed && 'root_fixed',
                `root_${theme}`,
            )}
        >
            <div
                className={cx('progress')}
                style={{width: `${percent * 100}%`}}
            />
            <div
                className={cx(
                    'content',
                    deviceMods('content', deviceType),
                    contentClassName,
                )}
            >
                {children}
            </div>
        </div>
    );
};
