import React from 'react';

import {IWithClassName} from 'types/withClassName';

import TicketCutout from './components/TicketCutout/TicketCutout';

import cx from './PromoCode.scss';

export enum EPromoCodeColor {
    BLUE = 'blue',
}

interface IPromoCodeProps extends IWithClassName {
    value: string;
    color: EPromoCodeColor;
}

const PromoCode: React.FC<IPromoCodeProps> = ({
    value,
    className,
    color = EPromoCodeColor.BLUE,
}) => {
    return (
        <div className={cx('root', `root_${color}`, className)}>
            <TicketCutout
                isRight={false}
                offsetClassName={cx('cutoutOffset')}
                cutoutClassName={cx('cutout')}
            />
            <div className={cx('content')}>{value}</div>
            <TicketCutout
                isRight
                offsetClassName={cx('cutoutOffset')}
                cutoutClassName={cx('cutout')}
            />
        </div>
    );
};

export default PromoCode;
