import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';

import cx from './TicketCutout.scss';

interface ITicketCutoutProps extends IWithClassName {
    isRight: boolean;
    offsetClassName: string;
    cutoutClassName: string;
}

const TicketCutout: FunctionComponent<ITicketCutoutProps> = ({
    className,
    isRight,
    offsetClassName,
    cutoutClassName,
}) => {
    return (
        <div
            className={cx(
                'root',
                {root_type_right: isRight},
                {root_type_left: !isRight},
                className,
            )}
        >
            <div className={cx('topOffest', offsetClassName)} />
            <svg
                className={cx('cutout', cutoutClassName)}
                viewBox="0 0 10 20"
                width="10"
                height="20"
            >
                {isRight ? (
                    <path
                        fillRule="evenodd"
                        clipRule="evenodd"
                        d="M 0 0 H 10 C 5 0 0 5 0 10 C 0 15 5 20 10 20 H 0 Z"
                    />
                ) : (
                    <path
                        fillRule="evenodd"
                        clipRule="evenodd"
                        d="M 0 0 H 10 V 20 H 0 C 5 20 10 15 10 10 C 10 4 5 0 0 0 Z"
                    />
                )}
            </svg>
            <div className={cx('bottomOffset', offsetClassName)} />
        </div>
    );
};

export default TicketCutout;
