import {useState} from 'react';
import {Meta} from '@storybook/react/types-6-0';
import {noop} from 'lodash';

import {TStorybookFunctionComponent} from 'storybook/types';

import Box from 'components/Box/Box';
import StyleguidistSizeTable from 'components/StyleguidistSizeTable/StyleguidistSizeTable';

import RadioButton, {ERadioButtonState, IRadioButtonProps} from './RadioButton';

export default {
    title: 'Example/RadioButton',
    component: RadioButton,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    const [number, setNumber] = useState<string>();

    return (
        <div style={{width: '300px'}}>
            <RadioButton
                value={number}
                name="number"
                onChange={({target}): void => setNumber(target.value)}
                width="max"
            >
                <RadioButton.Radio value="one">Один</RadioButton.Radio>
                <RadioButton.Radio value="two">Два</RadioButton.Radio>
                <RadioButton.Radio value="three">Три</RadioButton.Radio>
            </RadioButton>
        </div>
    );
};

export const ThemeBetween: TStorybookFunctionComponent = () => {
    const [number, setNumber] = useState<string>();

    return (
        <div style={{width: '600px'}}>
            <RadioButton
                value={number}
                name="number"
                onChange={({target}): void => setNumber(target.value)}
                width="max"
                theme="between"
            >
                <RadioButton.Radio value="one">Один</RadioButton.Radio>
                <RadioButton.Radio value="two">Два</RadioButton.Radio>
                <RadioButton.Radio value="three" disabled>
                    disabled
                </RadioButton.Radio>
            </RadioButton>
        </div>
    );
};

const sizeTemplate = (size: IRadioButtonProps['size']) => (
    <div style={{width: '200px'}}>
        <RadioButton
            size={size}
            name={size}
            width="max"
            value="one"
            onChange={noop}
        >
            <RadioButton.Radio value="one">Один</RadioButton.Radio>
            <RadioButton.Radio value="two">Два</RadioButton.Radio>
        </RadioButton>
    </div>
);

export const Sizes: TStorybookFunctionComponent = () => (
    <StyleguidistSizeTable
        sizes={[
            {
                name: 's',
                example: sizeTemplate('s'),
            },
            {
                name: 'm-inset',
                example: sizeTemplate('m-inset'),
            },
            {
                name: 'm',
                example: sizeTemplate('m'),
            },
            {
                name: 'l',
                example: sizeTemplate('l'),
            },
            {
                name: 'xl',
                example: sizeTemplate('xl'),
            },
        ]}
    />
);

export const Error: TStorybookFunctionComponent = () => (
    <RadioButton
        value="one"
        name="error"
        state={ERadioButtonState.ERROR}
        onChange={noop}
        width="max"
    >
        <RadioButton.Radio value="one">Один</RadioButton.Radio>
        <RadioButton.Radio value="two">Два</RadioButton.Radio>
        <RadioButton.Radio value="three">Три</RadioButton.Radio>
    </RadioButton>
);

export const Disabled: TStorybookFunctionComponent = () => (
    <Box between="2">
        <div style={{width: '200px'}}>
            <RadioButton
                name="first"
                disabled={true}
                onChange={noop}
                width="max"
            >
                <RadioButton.Radio value="one">Один</RadioButton.Radio>
                <RadioButton.Radio value="two">Два</RadioButton.Radio>
            </RadioButton>
        </div>
        <div style={{width: '200px'}}>
            <RadioButton name="second" onChange={noop} width="max">
                <RadioButton.Radio value="one">Один</RadioButton.Radio>
                <RadioButton.Radio value="two" disabled={true}>
                    Два
                </RadioButton.Radio>
                <RadioButton.Radio value="three">Три</RadioButton.Radio>
            </RadioButton>
        </div>
    </Box>
);
